from ninja import NinjaAPI
from .auth import router as auth_router
from .posts import router as posts_router
from .comments import router as comments_router
from .likes import router as likes_router
from .categories import router as categories_router
from .uploads import router as uploads_router

main_router = NinjaAPI(version="1.0.0", urls_namespace="main")

main_router.add_router("/api/v1/auth", auth_router)
main_router.add_router("/api/v1/posts", posts_router)
main_router.add_router("/api/v1/comments", comments_router)
main_router.add_router("/api/v1/likes", likes_router)
main_router.add_router("/api/v1/categories", categories_router)
main_router.add_router("/api/v1/uploads", uploads_router)
