export class AudioPlayer {
  private audio: HTMLAudioElement
  onTimeUpdate?: (time: number) => void
  onEnded?: () => void

  constructor() {
    this.audio = new Audio()
    this.audio.addEventListener('timeupdate', () => {
      this.onTimeUpdate?.(this.audio.currentTime)
    })
    this.audio.addEventListener('ended', () => {
      this.onEnded?.()
    })
  }

  async loadSong(url: string): Promise<void> {
    this.audio.src = url
    await this.audio.load()
  }

  async play(): Promise<void> {
    try {
      await this.audio.play()
    } catch (error) {
      console.error('Error playing audio:', error)
      throw error
    }
  }

  pause(): void {
    this.audio.pause()
  }

  seek(time: number): void {
    if (time >= 0 && time <= this.audio.duration) {
      this.audio.currentTime = time
    }
  }

  setVolume(volume: number): void {
    this.audio.volume = Math.max(0, Math.min(1, volume))
  }

  getCurrentTime(): number {
    return this.audio.currentTime
  }

  getDuration(): number {
    return this.audio.duration
  }
}
