import { createApp } from 'vue'
import { createPinia } from 'pinia'
import App from './App.vue'
import router from './router';
import './assets/tailwind.css'
import { HomeIcon, ClockIcon, FireIcon, PlusCircleIcon, TagIcon, DocumentTextIcon, GlobeAltIcon } from '@heroicons/vue/24/outline'
import axios from 'axios'

const app = createApp(App)
const pinia = createPinia()

app.component('HomeIcon', HomeIcon)
app.component('ClockIcon', ClockIcon)
app.component('FireIcon', FireIcon)
app.component('PlusCircleIcon', PlusCircleIcon)
app.component('TagIcon', TagIcon)
app.component('DocumentTextIcon', DocumentTextIcon)
app.component('GlobeAltIcon', GlobeAltIcon)

app.use(pinia)
app.use(router)

axios.defaults.baseURL = 'https://domaintestaccount.store'

app.mount('#app');