import { ref } from 'vue'

export interface ToastOptions {
  message: string
  type: 'success' | 'error' | 'info'
  duration?: number
}

const visible = ref(false)
const message = ref('')
const type = ref<'success' | 'error' | 'info'>('info')
let timeoutId: number | null = null

export const useToast = () => {
  const show = ({ message: msg, type: tp, duration = 3000 }: ToastOptions) => {
    if (timeoutId) {
      clearTimeout(timeoutId)
    }

    message.value = msg
    type.value = tp
    visible.value = true

    timeoutId = window.setTimeout(() => {
      visible.value = false
    }, duration)
  }

  const hide = () => {
    visible.value = false
    if (timeoutId) {
      clearTimeout(timeoutId)
    }
  }

  return {
    visible,
    message,
    type,
    show,
    hide
  }
}

// 创建全局单例
export const toast = useToast()
